<?php
namespace Services;

class TelegramClient
{
    private string $botToken;
    private string $apiBase;

    public function __construct(string $botToken)
    {
        $this->botToken = $botToken;
        $this->apiBase = "https://api.telegram.org/bot{$this->botToken}/";
    }

    public function sendMessage(string $chatId, string $text, array $options = []): ?array
    {
        $payload = array_merge([
            'chat_id' => $chatId,
            'text' => $text,
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => false,
        ], $options);

        return $this->request('sendMessage', $payload);
    }

    public function sendPhoto(string $chatId, string $photoUrl, string $caption = ''): ?array
    {
        $payload = [
            'chat_id' => $chatId,
            'photo' => $photoUrl,
            'caption' => $caption,
            'parse_mode' => 'HTML',
        ];

        return $this->request('sendPhoto', $payload);
    }

    private function request(string $method, array $params): ?array
    {
        $url = $this->apiBase . $method;

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POSTFIELDS => $params,
        ]);

        $response = curl_exec($ch);
        if ($response === false) {
            $error = curl_error($ch);
            curl_close($ch);
            throw new \Exception('Telegram API error: ' . $error);
        }
        curl_close($ch);

        return json_decode($response, true);
    }
}
