<?php
require __DIR__ . '/../bootstrap.php';

use Core\Auth;
use Core\DB;

Auth::requireRole(['admin']);

$active = 'telegram_bots';
$message = null;
$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? 'create';

    if ($action === 'create') {
        $name = trim($_POST['name'] ?? '');
        $bot_token = trim($_POST['bot_token'] ?? '');
        $platform = 'telegram';

        if (!$name || !$bot_token) {
            $error = 'الاسم و Bot Token مطلوبان.';
        } else {
            DB::query('INSERT INTO social_accounts (user_id, platform, name, bot_token, status, created_at, updated_at)
                VALUES (NULL, :platform, :name, :bt, "active", NOW(), NOW())', [
                'platform' => $platform,
                'name' => $name,
                'bt' => $bot_token,
            ]);
            $message = 'تم إضافة البوت بنجاح.';
        }
    } elseif ($action === 'update') {
        $id = (int)($_POST['id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $bot_token = trim($_POST['bot_token'] ?? '');
        $status = $_POST['status'] ?? 'active';

        if ($id <= 0) {
            $error = 'معرف غير صالح.';
        } else {
            DB::query('UPDATE social_accounts 
                       SET name = :name, bot_token = :bt, status = :st, updated_at = NOW()
                       WHERE id = :id AND platform = "telegram"', [
                'id' => $id,
                'name' => $name,
                'bt' => $bot_token,
                'st' => $status,
            ]);
            $message = 'تم تحديث البوت بنجاح.';
        }
    } elseif ($action === 'delete') {
        $id = (int)($_POST['id'] ?? 0);
        if ($id > 0) {
            DB::query('DELETE FROM social_accounts WHERE id = :id AND platform = "telegram"', ['id' => $id]);
            $message = 'تم حذف البوت.';
        }
    }
}

$editBot = null;
if (isset($_GET['edit_id'])) {
    $editId = (int)$_GET['edit_id'];
    $stmt = DB::query('SELECT * FROM social_accounts WHERE id = :id AND platform = "telegram" LIMIT 1', ['id' => $editId]);
    $editBot = $stmt->fetch();
}

$bots = DB::query("SELECT * FROM social_accounts WHERE platform = 'telegram' ORDER BY id DESC")->fetchAll();

include __DIR__ . '/_layout_header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3>بوتات تليجرام</h3>
</div>

<?php if($message): ?>
  <div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>
<?php if($error): ?>
  <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<div class="card mb-4">
  <div class="card-header"><?= $editBot ? 'تعديل بوت' : 'إضافة بوت جديد' ?></div>
  <div class="card-body">
    <form method="post">
      <input type="hidden" name="action" value="<?= $editBot ? 'update' : 'create' ?>">
      <?php if($editBot): ?>
        <input type="hidden" name="id" value="<?= $editBot['id'] ?>">
      <?php endif; ?>
      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">اسم داخلي للبوت</label>
          <input type="text" name="name" class="form-control" required value="<?= htmlspecialchars($editBot['name'] ?? '') ?>">
        </div>
        <div class="col-md-8">
          <label class="form-label">Bot Token</label>
          <input type="text" name="bot_token" class="form-control" required value="<?= htmlspecialchars($editBot['bot_token'] ?? '') ?>">
          <div class="form-text">الـ Token الذي تحصل عليه من BotFather.</div>
        </div>
        <?php if($editBot): ?>
        <div class="col-md-4">
          <label class="form-label">الحالة</label>
          <select name="status" class="form-select">
            <option value="active" <?= $editBot['status'] === 'active' ? 'selected' : '' ?>>نشط</option>
            <option value="inactive" <?= $editBot['status'] === 'inactive' ? 'selected' : '' ?>>متوقف</option>
          </select>
        </div>
        <?php endif; ?>
      </div>
      <button class="btn btn-primary mt-3"><?= $editBot ? 'تحديث' : 'حفظ' ?></button>
      <?php if($editBot): ?>
        <a href="telegram_bots.php" class="btn btn-secondary mt-3 ms-2">إلغاء التعديل</a>
      <?php endif; ?>
    </form>
  </div>
</div>

<div class="card">
  <div class="card-header">القائمة</div>
  <div class="card-body p-0">
    <table class="table table-striped table-sm mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>الاسم</th>
          <th>Bot Token</th>
          <th>الحالة</th>
          <th>خيارات</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($bots as $b): ?>
        <tr>
          <td><?= $b['id'] ?></td>
          <td><?= htmlspecialchars($b['name']) ?></td>
          <td><?= $b['bot_token'] ? '*** محفوظ ***' : 'غير مضبوط' ?></td>
          <td><?= htmlspecialchars($b['status']) ?></td>
          <td>
            <a href="telegram_bots.php?edit_id=<?= $b['id'] ?>" class="btn btn-sm btn-outline-primary">تعديل</a>
            <form method="post" class="d-inline" onsubmit="return confirm('هل تريد حذف هذا البوت؟');">
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="id" value="<?= $b['id'] ?>">
              <button class="btn btn-sm btn-outline-danger">حذف</button>
            </form>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/_layout_footer.php'; ?>
