<?php
require __DIR__ . '/../bootstrap.php';

use Core\Auth;
use Core\DB;

if (!Auth::check()) {
    header('Location: login.php');
    exit;
}

$active = 'dashboard';

$stats = [
    'twitter_accounts' => DB::query("SELECT COUNT(*) c FROM social_accounts WHERE platform = 'twitter'")->fetch()['c'] ?? 0,
    'telegram_targets' => DB::query("SELECT COUNT(*) c FROM telegram_targets")->fetch()['c'] ?? 0,
    'tweets_today' => DB::query("SELECT COUNT(*) c FROM posts WHERE DATE(created_at) = CURDATE()")->fetch()['c'] ?? 0,
    'posts_today' => DB::query("SELECT COUNT(*) c FROM post_logs WHERE DATE(created_at) = CURDATE()")->fetch()['c'] ?? 0,
];

$recentPublishes = DB::query("
    SELECT pl.*, p.tweet_url, ts.display_name AS source_name, tt.display_name AS telegram_target_name
    FROM post_logs pl
    INNER JOIN posts p ON p.id = pl.post_id
    INNER JOIN publishing_rules pr ON pr.id = pl.publishing_rule_id
    INNER JOIN twitter_sources ts ON ts.id = pr.twitter_source_id
    INNER JOIN telegram_targets tt ON tt.id = pr.telegram_target_id
    ORDER BY pl.id DESC
    LIMIT 20
")->fetchAll();

include __DIR__ . '/_layout_header.php';
?>
<div class="container-fluid">
  <h3 class="mb-4">لوحة التحكم</h3>
  <div class="row mb-4">
    <div class="col-md-3">
      <div class="card shadow-sm mb-3">
        <div class="card-body">
          <h6 class="text-muted mb-1">حسابات تويتر (API)</h6>
          <h3 class="mb-0"><?= $stats['twitter_accounts'] ?></h3>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card shadow-sm mb-3">
        <div class="card-body">
          <h6 class="text-muted mb-1">قنوات / بوتات تليجرام</h6>
          <h3 class="mb-0"><?= $stats['telegram_targets'] ?></h3>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card shadow-sm mb-3">
        <div class="card-body">
          <h6 class="text-muted mb-1">تغريدات مسحوبة اليوم</h6>
          <h3 class="mb-0"><?= $stats['tweets_today'] ?></h3>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card shadow-sm mb-3">
        <div class="card-body">
          <h6 class="text-muted mb-1">منشورات تليجرام اليوم</h6>
          <h3 class="mb-0"><?= $stats['posts_today'] ?></h3>
        </div>
      </div>
    </div>
  </div>

  <div class="card shadow-sm">
    <div class="card-header">
      أحدث عمليات النشر
    </div>
    <div class="card-body p-0">
      <table class="table table-striped table-sm mb-0">
        <thead>
          <tr>
            <th>#</th>
            <th>المصدر</th>
            <th>الوجهة</th>
            <th>التغريدة</th>
            <th>التاريخ</th>
            <th>الحالة</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($recentPublishes as $item): ?>
          <tr>
            <td><?= $item['id'] ?></td>
            <td><?= htmlspecialchars($item['source_name']) ?></td>
            <td><?= htmlspecialchars($item['telegram_target_name']) ?></td>
            <td><a href="<?= htmlspecialchars($item['tweet_url']) ?>" target="_blank">عرض</a></td>
            <td><?= htmlspecialchars($item['created_at']) ?></td>
            <td>
              <?php if ($item['status'] === 'success'): ?>
                <span class="badge bg-success">نجاح</span>
              <?php else: ?>
                <span class="badge bg-danger">فشل</span>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php include __DIR__ . '/_layout_footer.php'; ?>
