<?php
require_once __DIR__ . '/auth.php';
require_login();
require_once __DIR__ . '/header.php';
global $mysqli;

// إجمالي عدد الملفات
$totalFilesRes = $mysqli->query("SELECT COUNT(*) AS c FROM uploaded_files");
$totalFilesRow = $totalFilesRes->fetch_assoc();
$totalFiles = (int)$totalFilesRow['c'];

// إجمالي التحويلات البنكية (من جدول التفاصيل)
$totalBankRes = $mysqli->query("SELECT SUM(bank_amount) AS s FROM expenses_details");
$totalBankRow = $totalBankRes->fetch_assoc();
$totalBank = $totalBankRow['s'] ?? 0;

// آخر 5 ملفات
$lastFilesRes = $mysqli->query("
    SELECT uf.*, u.name AS user_name
    FROM uploaded_files uf
    JOIN users u ON u.id = uf.user_id
    ORDER BY uf.created_at DESC
    LIMIT 5
");
?>

<div class="row mb-4">
  <div class="col-md-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <h6 class="text-muted">إجمالي الملفات</h6>
        <h3><?= $totalFiles ?></h3>
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <h6 class="text-muted">إجمالي التحويلات البنكية المسجلة</h6>
        <h3><?= number_format((float)$totalBank, 2) ?></h3>
      </div>
    </div>
  </div>
</div>

<div class="card shadow-sm mb-4">
  <div class="card-body">
    <h5 class="card-title mb-3">آخر الملفات المرفوعة</h5>
    <table class="table table-sm table-hover">
      <thead>
        <tr>
          <th>#</th>
          <th>اسم الملف</th>
          <th>المستخدم</th>
          <th>الحالة</th>
          <th>تاريخ الرفع</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($f = $lastFilesRes->fetch_assoc()): ?>
        <tr>
          <td><?= $f['id'] ?></td>
          <td><?= htmlspecialchars($f['original_name']) ?></td>
          <td><?= htmlspecialchars($f['user_name']) ?></td>
          <td><?= htmlspecialchars($f['status']) ?></td>
          <td><?= htmlspecialchars($f['created_at']) ?></td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/footer.php'; ?>
