<?php
require_once __DIR__ . '/auth.php';
require_login();
require_once __DIR__ . '/header.php';
global $mysqli;

// يمكن حصرها على الأدمن فقط إن رغبت:
// require_role('admin');

$res = $mysqli->query("
    SELECT al.*, u.name AS user_name
    FROM activity_logs al
    LEFT JOIN users u ON u.id = al.user_id
    ORDER BY al.created_at DESC
    LIMIT 100
");
?>

<div class="card shadow-sm">
  <div class="card-body">
    <h4 class="mb-3">سجل النشاطات (آخر 100 عملية)</h4>
    <table class="table table-sm table-striped">
      <thead>
        <tr>
          <th>التاريخ</th>
          <th>المستخدم</th>
          <th>العملية</th>
          <th>الوصف</th>
          <th>IP</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($row = $res->fetch_assoc()): ?>
        <tr>
          <td><?= htmlspecialchars($row['created_at']) ?></td>
          <td><?= htmlspecialchars($row['user_name'] ?? 'زائر') ?></td>
          <td><?= htmlspecialchars($row['action']) ?></td>
          <td><?= htmlspecialchars($row['description']) ?></td>
          <td><?= htmlspecialchars($row['ip_address']) ?></td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/footer.php'; ?>
