<?php
require_once __DIR__ . '/auth.php';
require_login();
require_once __DIR__ . '/header.php';
global $mysqli;

$res = $mysqli->query("
    SELECT uf.*, u.name AS user_name
    FROM uploaded_files uf
    JOIN users u ON u.id = uf.user_id
    ORDER BY uf.created_at DESC
");
?>

<div class="card shadow-sm">
  <div class="card-body">
    <h4 class="mb-3">الملفات المرفوعة</h4>
    <table class="table table-hover table-sm">
      <thead>
        <tr>
          <th>#</th>
          <th>اسم الملف</th>
          <th>المستخدم</th>
          <th>الحالة</th>
          <th>الحجم (بايت)</th>
          <th>تاريخ الرفع</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($f = $res->fetch_assoc()): ?>
        <tr>
          <td><?= $f['id'] ?></td>
          <td><?= htmlspecialchars($f['original_name']) ?></td>
          <td><?= htmlspecialchars($f['user_name']) ?></td>
          <td><?= htmlspecialchars($f['status']) ?></td>
          <td><?= number_format((float)$f['size']) ?></td>
          <td><?= htmlspecialchars($f['created_at']) ?></td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/footer.php'; ?>
