<?php
namespace Core;

use Core\DB;

class Auth
{
    private static string $sessionName;

    public static function init(string $sessionName): void
    {
        self::$sessionName = $sessionName;
        if (!isset($_SESSION[self::$sessionName])) {
            $_SESSION[self::$sessionName] = [];
        }
    }

    public static function attempt(string $email, string $password): bool
    {
        $stmt = DB::query('SELECT * FROM users WHERE email = :email LIMIT 1', ['email' => $email]);
        $user = $stmt->fetch();
        if ($user && password_verify($password, $user['password'])) {
            $_SESSION[self::$sessionName]['user'] = [
                'id' => $user['id'],
                'name' => $user['name'],
                'email' => $user['email'],
                'role' => $user['role'],
            ];
            return true;
        }
        return false;
    }

    public static function user(): ?array
    {
        return $_SESSION[self::$sessionName]['user'] ?? null;
    }

    public static function check(): bool
    {
        return self::user() !== null;
    }

    public static function logout(): void
    {
        unset($_SESSION[self::$sessionName]['user']);
    }

    public static function requireRole(array $roles = ['admin']): void
    {
        $user = self::user();
        if (!$user || !in_array($user['role'], $roles)) {
            header('Location: login.php');
            exit;
        }
    }
}
